<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

print_cp_header($vbphrase['dbtech_downloads']);

print_table_start();

print_table_header($vbphrase['dbtech_downloads'], 4);

$bandusage = $db->query_first("
	SELECT SUM(filesize) AS size, COUNT(fileid) AS files FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
");

$timecutoff = TIMENOW - (60 * 60 * 24 * 30); // 1 month

$monthbandusage = $db->query_first("
	SELECT SUM(filesize) AS size FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
	WHERE dateline > $timecutoff
");
	
	print_cells_row(array(
		$vbphrase['dbtech_downloads_system_status'],
		$vbulletin->options['dbtech_downloads_online'] == true ? $vbphrase['dbtech_downloads_system_online'] : $vbphrase['dbtech_downloads_system_offline'],
		
		$vbphrase['dbtech_downloads_system_version'],
		'<span style="font-weight: bold;">' . $vbulletin->options['dbtech_downloads_version'] . '<span>'
	), 0, 0, -5, 'top', 1, 1);

	print_cells_row(array(
		$vbphrase['dbtech_downloads_bandwidth_usage'],
		Downloads::convert_filesize($bandusage['size']),
		
		$vbphrase['dbtech_downloads_memory_limit'],
		ini_get('memory_limit')
		
	), 0, 0, -5, 'top', 1, 1);
	
	print_cells_row(array(
		$vbphrase['dbtech_downloads_bandwidth_usage_monthly'],
		Downloads::convert_filesize($monthbandusage['size']),
		
		$vbphrase['dbtech_downloads_max_upload_size'],
		ini_get('upload_max_filesize')
	), 0, 0, -5, 'top', 1, 1);
	
	print_cells_row(array(
		$vbphrase['dbtech_downloads_files'],
		$bandusage['files'],
		
		$vbphrase['dbtech_downloads_max_input_time'],
		ini_get('max_input_time') . ' seconds'
	), 0, 0, -5, 'top', 1, 1);

print_table_footer(2);

print_cp_footer();